/*
 * Decompiled with CFR 0.152.
 */
package Project.Editor.Components;

import Data_Structures.Structures.BitSet;
import Data_Structures.Structures.HashingClasses.Dict;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Obj_Container;
import Game_Engine.levelEditor.editor_components.gui_level_editor;
import Game_Engine.levelEditor.editor_components.obj_grid;
import Game_Engine.levelEditor.entities.Ent_aaScalable;
import Project.Editor.Components.Spr;
import Project.Game.Componenets.guiBox;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import util.FileIO;
import util.Serializations;
import util.StringParser;

public class puzzle_editor
extends gui_level_editor {
    public puzzle_editor(double x, double y, int w, int h) {
        super(x, y, w, h);
        puzzle_editor.createHud(this);
    }

    @Override
    public String getExtension() {
        return "TTT";
    }

    @Override
    public void serializeFrom(File file) {
        this.killEntities();
        puzzle_editor.createHud(this).allowEditing();
        List<String> input = FileIO.readFile(file);
        Iterator<String> iter2 = input.iterator();
        iter2.next();
        iter2.next();
        iter2.next();
        while (iter2.hasNext()) {
            String entity_name = iter2.next();
            if (entity_name.equals("obj_guiBox")) {
                guiBox.setGoal(new Integer(iter2.next()));
                continue;
            }
            Dict<String> dict = Serializations.deserial_dict(iter2);
            int x = new Integer((String)dict.lookup("x"));
            int y = new Integer((String)dict.lookup("y"));
            if (entity_name.startsWith("obj_piece")) {
                int index = StringParser.getEndDigit(entity_name);
                Ent_aaScalable o = new Ent_aaScalable(x, y, Spr.mover[index], entity_name);
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                o.arg2(x2, y2);
                o.setDirectionsAttributes(new BitSet((String)dict.lookup("dir")));
                this.obj_create((Obj)o);
                continue;
            }
            if (entity_name.startsWith("obj_teleporterPad")) {
                int index = StringParser.getEndDigit(entity_name);
                Ent_aaScalable o = new Ent_aaScalable(x, y, Spr.teleporter[index], entity_name);
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                o.arg2(x2, y2);
                o.setDirectionsAttributes(new BitSet((String)dict.lookup("dir")));
                this.obj_create((Obj)o);
                continue;
            }
            if (entity_name.startsWith("obj_teleporter_target_mover")) {
                int index = StringParser.getEndDigit(entity_name);
                Ent_aaScalable o = new Ent_aaScalable(x, y, Spr.teleporter_target_mover[index], entity_name);
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                o.arg2(x2, y2);
                o.setDirectionsAttributes(new BitSet((String)dict.lookup("dir")));
                this.obj_create((Obj)o);
                continue;
            }
            if (entity_name.startsWith("obj_teleport_target_teleporter")) {
                int index = StringParser.getEndDigit(entity_name);
                Ent_aaScalable o = new Ent_aaScalable(x, y, Spr.teleport_target_teleporter[index], entity_name);
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                o.arg2(x2, y2);
                o.setDirectionsAttributes(new BitSet((String)dict.lookup("dir")));
                this.obj_create((Obj)o);
                continue;
            }
            if (entity_name.startsWith("obj_goal")) {
                int index = StringParser.getEndDigit(entity_name);
                Ent_aaScalable o = new Ent_aaScalable(x, y, Spr.goal[index], entity_name);
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                o.arg2(x2, y2);
                o.setDirectionsAttributes(new BitSet((String)dict.lookup("dir")));
                this.obj_create((Obj)o);
                continue;
            }
            if (entity_name.equals("obj_ground_square")) {
                Ent_aaScalable o = new Ent_aaScalable(x, y, Spr.ground_square, entity_name);
                int x2 = new Integer((String)dict.lookup("x2"));
                int y2 = new Integer((String)dict.lookup("y2"));
                o.arg2(x2, y2);
                o.setDirectionsAttributes(new BitSet((String)dict.lookup("dir")));
                o.setDepth(5);
                this.obj_create((Obj)o);
                continue;
            }
            if (!entity_name.startsWith("obj_wall")) continue;
            int index = StringParser.getEndDigit(entity_name);
            if (index >= 4) {
                Ent_aaScalable o = new Ent_aaScalable(x, y, Spr.wall[index], entity_name);
                this.obj_create((Obj)o);
                continue;
            }
            Ent_aaScalable o = new Ent_aaScalable(x, y, Spr.wall[index], entity_name);
            Integer x2 = new Integer((String)dict.lookup("x2"));
            Integer y2 = new Integer((String)dict.lookup("y2"));
            o.arg2(x2, y2);
            this.obj_create((Obj)o);
        }
        this.redraw();
    }

    @Override
    public obj_grid getGridObj() {
        return new obj_grid(32, 16, 64, 64);
    }

    public static guiBox createHud(Obj_Container c) {
        guiBox b = new guiBox(c.getW() - 256 - 32 - guiBox.getBorderSize() * 2, 16.0, 256, 64);
        b.allowEditing();
        c.obj_create((Obj)b);
        return b;
    }

    @Override
    protected void serializeNonEntities(PrintStream stream) {
        stream.println("obj_guiBox");
        stream.println(guiBox.getGoal());
    }
}

